#ifndef	_ADT8940a1_H__
#define	_ADT8940a1_H__

typedef void (*FUNCTION)();

int  adt8940a1_initial(void);
/* Initialize card
(1) Return >0 means amount of installed adt8940 cards; in case the returning value is 3, the available card numbers shall be 0, 1, and 2;
(2) Return =0 means no installation of adt8940 card;
(3) Return <0 means no installation of service if the value is -1 or PCI bus failure is the value is -2.
*/

int  get_lib_version(int cardno);
/* Get current library version
Here returns are combination of hardware and library version number.
Return 110 means that the hardware version is 1 and the library version is 1.0,
return 220 means that the hardware version is 2 and the library version is 2.0, and so on.
*/

float  get_hardware_ver(int cardno);
/* Get current hardware version
Here returns are combination of hardware and hardware version number.
*/

int  set_pulse_mode(int cardno,int axis,int value,int logic,int dir_logic);
/* Set outputted pulse mode
cardno	    Card number
axis		Axis number (1-4)
value       0Pulse + Pulse method	    1Pulse + direction method
logic		0	Positive logic pulse	1Negative logic pulse
dir_logic	0 Positive logic direction input signal 	1Negative logic direction input signal
Return	    0Correct					1 Wrong
Default mode: Pulse + direction, with positive logic pulse and positive logic direction input signal
*/

int  set_limit_mode(int cardno,int axis,int v1,int v2,int logic);
/*Set mode of nLMT signal input along positive/ negative direction
cardno	Card number
axis	Axis number (1-4)
v1		0: positive limit effective	1: positive limit ineffective
v2		0: negative limit effective 1: negative limit ineffective
logic	0: low level effective		1: high level ineffective
Return	0Correct					1 Wrong
Default mode: Apply positive and negative limits with low level
*/

int  set_stop0_mode(int cardno,int axis,int v,int logic);
/*Set mode of stop0 input signal
cardno	Card number
axis	Axis number (1-4)
v		0: ineffective		    1: effective
logic	0: low level effective	1: high level effective
Return	0: Correct				1: Wrong
Default mode: ineffective
*/

int  set_stop1_mode(int cardno,int axis,int v,int logic);
/*Set mode of stop1 input signal
cardno	Card number
axis	Axis number (1-4)
v		0: ineffective		    1: effective
logic	0: low level effective	1: high level effective
Return	0: Correct				1: Wrong
Default mode: ineffective
*/

int  set_delay_time(int cardno,long time);
/*function: Set delay time 
para
cardno	Card number
time    delay time   (Uint:1/8us)
Return	0: Correct				1: Wrong  
Remark: The time unit is 1/8us, with the maximum integer value as its maximum
*/

int  set_suddenstop_mode(int cardno,int v,int logical);
/*function: hardware stop
para
cardno	Card number
v		0: ineffective		    1: effective
logical 0low level effective	1high level effective
Return	0: Correct				1: Wrong 
Remark: Hardware stop signals are assigned to use the 34 pin at the P3 terminal panel (IN31)
*/

//----------------------------------------------------//
//          CATEGORY OF MOTION STATUS CHECK           //
//----------------------------------------------------//

int  get_status(int cardno,int axis,int *v);
/*Get status of single-axis drive
cardno	Card number
axis	Axis number (1-4)
value	Indicator of drive status
0Drive completed
Non-0: Drive in process
Return	0: Correct				1: Wrong
*/

int  get_inp_status(int cardno,int *v);
/*Get status of Interpolation
cardno	Card number
value   Indicator of i Interpolation:
0: Interpolation completed	
1: Interpolation in process
Return	0: Correct				1: Wrong
*/

int  get_delay_status(int cardno);
/*Get status of delay 
cardno	Card number
Return	0: delay completed			1: delay in process
*/

//----------------------------------------------------//
//        CATEGORY OF MOTION  PARAMETER SETTING       //
//----------------------------------------------------//
int  set_acc(int cardno, int axis,long add);
/*Set acceleration
cardno	Card number
axis	Axis number 
add     acceleration(0-32000) 
Return 	0: Correct				1: Wrong  
*/

int  set_startv(int cardno, int axis,long speed);
/*Set starting speed
cardno	Card number
axis	Axis number
value	Speed(0-2M)
*/

int  set_speed(int cardno, int axis,long speed);
/*Set drive speed
cardno	Card number
axis	Axis number
value	Speed(0-2M)
*/

int  set_command_pos(int cardno, int axis,long pos);
/*set values for the logical position counter
cardno	Card number
axis	Axis number
value	Range (-2147483648~+2147483647)
Return	0: Correct				1: Wrong
*/

int  set_actual_pos(int cardno, int axis,long pos);
/*set values for the actual position counter
cardno	Card number
axis	Axis number
value	Range (-2147483648~+2147483647)
Return	0: Correct				1: Wrong
*/

int  set_symmetry_speed(int cardno, int axis,long lspd,long hspd,double tacc);
/*set values for the actual position counter
cardno	Card number
axis	Axis number
lspd    start speed
hspd    running speed
tacc    acceleration time
Return	0: Correct				1: Wrong
Remark: This function is a combination of multiple functions,
        such as set_acc,set_startv,set_speed etc. 
*/

//----------------------------------------------------//
//      CATEGORY OF MOTION PARAMETER CHECK            //
//----------------------------------------------------//

int  get_command_pos(int cardno,int axis,long *pos);
/*Get logical position of each axis
cardno	Card number
axis	Axis number
pos		Indicator of logical position value
Return  0: Correct				1: Wrong
*/

int  get_actual_pos(int cardno,int axis,long *pos);
/*Get actual position of each axis (i.e., encoder feedback input)
cardno	Card number
axis	Axis number
pos		Indicator of actual position value
Return  0: Correct				1: Wrong
*/

int  get_speed(int cardno,int axis,long *speed);
/*Get current speed
cardno	Card number
axis	Axis number
speed	Indicator of current drive speed
Return	0: Correct				1: Wrong

*/

int  get_out(int cardno, int number);
/*Get current Output status
cardno	Card number
axis	Axis number
Return	current Output status			-1: Wrong

*/
//----------------------------------------------------//
//                 CATEGORY OF MOTION                 //
//----------------------------------------------------//

int  pmove(int cardno,int axis,long pos);
/*Single-axis quantitative drive
cardno 	Card number
axis	Axis number
pulse 	Outputted pulses
>0: move along positive direction
<0: move along negative direction
Range (-268435455~+268435455)
Return	0: Correct				1: Wrong
*/

int  dec_stop(int cardno,int axis);
/* Deceleration stop
cradno	Card number
axis	Axis number
Return	0: Correct				1: Wrong
*/

int  sudden_stop(int cardno,int axis);
/*Sudden stop
cardno Card number
axis   Axis number
Return 0: Correct				1: Wrong
*/

int  inp_move2(int cardno,int axis1,int axis2,long pulse1,long pulse2);
/* 2-axis interpolation
cardno	        Card number
axis1,axis2     Axis number joining interpolation
pulse1,pulse2	Relative distance of movemen 
Range (-8388608~+8388607)
Return	0: Correct				1: Wrong
*/

int  inp_move3(int cardno,int axis1,int axis2,int axis3,long pulse1,long pulse2,long pulse3);
/*3-axis interpolation
cardno	        Card number
axis1,axis2,axis3  Axis number joining interpolation
pulse1,pulse2,pulse3	Relative distance of movemen 
Range (-8388608~+8388607)
Return	0: Correct				1: Wrong
*/

int  inp_move4(int cardno,long pulse1,long pulse2,long pulse3,long pulse4);
/*4-axis interpolation
cardno Card number		
pulse1,pulse2,pulse3,pulse4  Relative distance of movement along X-Y-Z-W axis
Range (-8388608~+8388607)
Return	0: Correct				1: Wrong
*/

//-------------------------------------------------//
//      CATEGORY OF SWITCH AMOUNT INPUT/ OUTPUT    //
//-------------------------------------------------//

int  read_bit(int cardno,int number);
/*Read single input point
cardno	Card number
number	Input point (0-39)
Return
0: low level
1: high level
-1: error
*/

int  write_bit(int cardno,int number,int value);
/*Output single output point
cardno	Card number
number	Output point (0-15)
value	0: low		1: high		
Return  0: correct  1: wrong
*/


int  set_suddenstop_mode(int cardno,int v,int logic);
/*Hardware stop
cardno	Card number
v       0: Apply;               1: Don't apply
logical 0: low level;           1: high level
Return	0: Correct				1: Wrong
Remark: Hardware stop signals are assigned to use the 34 pin at the P3 terminal panel (IN31)
*/

int  get_delay_status(int cardno);
/*Get delay status
cardno	Card number
Return  0: delay stop          1: delay in process
*/

int  set_delay_time(int cardno,long time);
/*set delay time
cardno	Card number
time    Delay time
Return	0: Correct				1: Wrong
Remark: The time unit is 1/8us, with the maximum integer value as its maximum value
*/

//*********************************************//
//               Composite drives              //
//*********************************************//


int  symmetry_relative_move(int cardno, int axis, long pulse, long lspd ,long hspd, double tacc);
/************ Symmetrical relative movement of single-axis ***************
function: Refer to the current position and perform quantitative movement in the symmetrical
acceleration/deceleration
para:
     cardno-card number
	 axis---axis number
	 pulse-- Pulse
	 lspd--- Low speed
	 hspd--- High speed
	 tacc--- Time of acceleration (Unit: sec)
return value 0correct 1wrong
*******************************************************************/

int  symmetry_absolute_move(int cardno, int axis, long pulse, long lspd ,long hspd, double tacc)  ;
/************** Symmetrical absolute movement of single-axis ***********
function: Refer to the position of zero point and perform quantitative movement in the symmetrical
acceleration/deceleration
para:
     cardno -card number
	 axis ---axis number
	 pulse -- Pulse
	 lspd --- Low speed
	 hspd --- High speed
	 tacc--- Time of acceleration (Unit: sec)
return value 0: correct 1: wrong
*******************************************************************/

int  symmetry_relative_line2(int cardno, int axis1, int axis2, long pulse1, long pulse2, long lspd ,long hspd, double tacc)  ;
/***** Relative movement of two-axis symmetrical linear interpolation ********
function: Refer to current position and perform linear interpolation in symmetrical
acceleration/deceleration
para:
     cardno-card number
	 axis1---axis number1
	 axis2---axis number2
	 pulse1-- pulse 1
	 pulse2-- pulse 2
	 lspd --- Low speed
	 hspd --- High speed
	 tacc--- Time of acceleration (Unit: sec)
return value 0correct 1wrong
******************************************************************/

int  symmetry_absolute_line2(int cardno, int axis1, int axis2, long pulse1, long pulse2, long lspd ,long hspd, double tacc);
/****** Two axes symmetric linear interpolation absolute moving ********
function: Refer to the position of zero point and perform linear interpolation in symmetrical
acceleration/deceleration
para:
     cardno-card number
	 axis1---axis number1
	 axis2---axis number2
	 pulse1pulse of axis 1
	 pulse2-- pulse of axis 2
	 lspd --- Low speed
	 hspd --- High speed
	 tacc--- Time of acceleration (Unit: sec)
return value 0correct 1wrong
******************************************************************/

int  symmetry_relative_line3(int cardno, int axis1, int axis2, int axis3, long pulse1, long pulse2, long pulse3, long lspd ,long hspd, double tacc)  ;
/***** Three axes symmetric linear interpolation relative moving ******
function: Refer to current position and perform linear interpolation in symmetric
acceleration/deceleration
para:
     cardno-card number
	 axis1---axis number1
	 axis2---axis number2
	 axis3---axis number3
	 pulse1-- pulse of axis 1
	 pulse2-- pulse of axis 2
	 pulse3-- pulse of axis 3
	 lspd --- Low speed
	 hspd --- High speed
	 tacc--- Time of acceleration (Unit: sec)
return value 0correct 1wrong
******************************************************************/

int  symmetry_absolute_line3(int cardno, int axis1, int axis2, int axis3, long pulse1, long pulse2, long pulse3, long lspd ,long hspd, double tacc)  ;
/******Three axes symmetric linear interpolation absolute moving **********
function: Refer to the position of zero point and perform linear interpolation in symmetric
acceleration/deceleration.
para:
     cardno-card number
	 axis1---axis number1
	 axis2---axis number2
	 axis3---axis number3
	 pulse1-- pulse of axis 1
	 pulse2-- pulse of axis 2
	 pulse3-- pulse of axis 3
	 lspd --- Low speed
	 hspd --- High speed
	 tacc--- Time of acceleration (Unit: sec)
return value 0correct 1wrong
******************************************************************/

int  symmetry_relative_line4(int cardno,long pulse1, long pulse2, long pulse3,  long pulse4,long lspd ,long hspd, double tacc);
/***** Four axes symmetric linear interpolation relative moving ******
function: Refer to current position and perform linear interpolation in symmetric
acceleration/deceleration
para:
     cardno-card number
	 pulse1-- pulse of axis 1
	 pulse2-- pulse of axis 2
	 pulse3-- pulse of axis 3
	 pulse4-- pulse of axis 4
	 lspd --- Low speed
	 hspd --- High speed
	 tacc--- Time of acceleration (Unit: sec)
return value 0correct 1wrong
******************************************************************/


int  symmetry_absolute_line4(int cardno, long pulse1, long pulse2, long pulse3, long pulse4,long lspd ,long hspd, double tacc);
/******Four axes symmetric linear interpolation absolute moving **********
function: Refer to the position of zero point and perform linear interpolation in symmetric
acceleration/deceleration.
para:
     cardno-card number
	 pulse1-- pulse of axis 1
	 pulse2-- pulse of axis 2
	 pulse3-- pulse of axis 3
	 pulse4-- pulse of axis 4
	 lspd --- Low speed
	 hspd --- High speed
	 tacc--- Time of acceleration (Unit: sec)
return value 0correct 1wrong
******************************************************************/

//*********************************************//
//         external signal drive               //
//*********************************************//

int   manual_pmove(int cardno, int axis, long pos);
/* Quantitative drive function of external signal 
function: Quantitative drive function of external signal
para:
     cardno card number
	 axis axis number
	 pulse pulse
Return 0Correct 1Wrong
Note: (1) Send out quantitative pulse, but the drive does not start immediately until the external
	  signal level changes
	  (2)Ordinary button and handwheel are acceptable.
*/

int   manual_continue(int cardno, int axis);
/*Continuous drive function of external signal 
function: Continuous drive function of external signal
para:
     cardno card number
	 axis axis number
Return 0Correct 1Wrong
Note: (1) Send out fixed pulse, but the drive does not start immediately until the level of external
signal changes
(2) Ordinary button and handwheel are acceptable.
*/

int   manual_disable(int cardno, int axis);
/* Shut down the enabling of external signal drive 
function: Shut down the enabling of external signal drive
para:
     cardno card number
     axis axis number
Return 0Correct 1Wrong
*/

//*********************************************//
//           lock  position                    //
//*********************************************//

int   set_lock_position(int cardno, int axis,int mode,int regi,int logical);
/*set lock mode
function:lock the logical position and real position for all axes
para: 
     cardno card number
     axis   reference axis
	 mode   set lock mode   0:inefficacy         1:efficiency
     regi   register mode   0:logical position   1:real position
     logicallevel signal    0: from high to low  1:from low to high
retutrn 0correct 1wrong
Note: Use IN signal of specific axis as the trigger signal
*/

int   get_lock_status(int cardno, int axis, int *v);
/*Function: Get the status of position lock
Parameter:
cardno      card number
axis         axis number(1-4)
status       Lock status (0: unlocked, 1: locked)
Return value         0:correct          1:wrong
****************************************************************************/

int   get_lock_position(int cardno,int axis,long *pos);
/**********************get lock position************************
Function: Get the locked position
para:
     cardno    card number
     axis      axis number
     pos       lock position
Return 0Correct 1Wrong
******************************************************************/

int   clr_lock_status(int cardno, int axis);
/**********************clean lock position************************
Function: Clean the locked position
para:
     cardno    card number
     axis      axis number
Return 0Correct 1Wrong
******************************************************************/


//*********************************************//
//                FIFO buffer                  //
//*********************************************//

int   _stdcall fifo_inp_move1(int cardno,int axis1,long pulse1,long speed);
/**************************single axis FIFO**************************
Function:single axis FIFO
para:
	cardno      card number
	axis1	    axis number(1-4)
	pulse1      pulses in FIFO buffer
	speed       FIFO speed 
Return 0Correct 1Wrong
******************************************************************/

int   _stdcall fifo_inp_move2(int cardno,int axis1,int axis2,long pulse1,long pulse2,long speed);
/**************************two axes FIFO**************************
Function:two axes FIFO
para:
	cardno      card number
	axis1	    axis number(1-4)
	axis2	    axis number(1-4)
	pulse1      pulses in FIFO buffer
	pulse2      pulses in FIFO buffer
	speed       FIFO speed 
Return 0Correct 1Wrong
******************************************************************/

int   _stdcall fifo_inp_move3(int cardno,int axis1,int axis2,int axis3,long pulse1,long pulse2,long pulse3,long speed);
/**************************three axes FIFO**************************
Function:three axes FIFO
para:
	cardno      card number
	axis1	    axis number(1-4)
	axis2	    axis number(1-4)
    axis3	    axis number(1-4)
	pulse1      pulses in FIFO buffer
	pulse2      pulses in FIFO buffer
	pulse3      pulses in FIFO buffer
	speed       FIFO speed 
Return 0Correct 1Wrong
******************************************************************/

int   _stdcall fifo_inp_move4(int cardno,long pulse1,long pulse2,long pulse3,long pulse4,long speed);
/**************************three axes FIFO**************************
Function:four axes FIFO
para:
	cardno      card number
	axis1	    axis number(1-4)
	axis2	    axis number(1-4)
    axis3	    axis number(1-4)
	axis4	    axis number(1-4)
	pulse1      pulses in FIFO buffer
	pulse2      pulses in FIFO buffer
	pulse3      pulses in FIFO buffer
	pulse4      pulses in FIFO buffer
	speed       FIFO speed 
Return 0Correct 1Wrong
******************************************************************/
int   _stdcall reset_fifo(int cardno);
/**************************reset fifo cache**************************
Function:reset fifo buffer
para:
	cardno      card number
Return 0Correct 1Wrong
******************************************************************/

int   _stdcall read_fifo_count(int cardno,int *value);
/**************************read fifo **********************
Function:read fifo cache,count the fifo command haven't been implemented 
para:
	cardno      card number
	value       the space(bytes) of commands that haven't been implemented     
Return 0Correct 1Wrong
******************************************************************/

int   _stdcall read_fifo_empty(int cardno);
/**************************read fifo **********************
Function:read the fifo buffer, count fifo whether it is a empty buffer
para:
	cardno      card number
Return 0Correct 1Wrong
******************************************************************/

int   _stdcall read_fifo_full(int cardno);
/**************************read fifo **********************
Function:read the fifo buffer, estimate for that whether the buffer is full
para:
	cardno      card number
Return 0Correct 1Wrong
******************************************************************/
int continue_move (int cardno, int axis, int dir);
/************************* Function: Single continuous movement ****************** ********
Function: Single continuous movement
Parameters:
cardno Card
axis axis number (1-4)
dir 0: positive; 1: Negative

  Returns: 1: parameter error; 0: correct.
  Note: Write-driven command, be sure to correctly set the speed parameters.
************************************************** ******************/
int home1 (int cardno, int axis, int backDir, int logical0, int logical1, long homeStartV, long homeSpeed,
		   long homeAcc, long searchRange, long searchSpeed, long phaseSpeed, long pulseUnit);
/************************** Axis back to the origin ******************* ***
Function: Perform single-axis movement back to the origin
Parameters:
cardno Card
axis axis number (1-4)
backDir direction back to the origin 0: positive 1: negative
logical0 back to the origin stop0 set 0: active low 1: active high
logical1 back to the origin stop1 set 0: active low 1: active high 1: invalid (does not search for Z-phase)
homeStartV back to the origin initiation speed, range :0-2M
homeSpeed ??back to the origin of drive speed, range :0-2M
homeAcc back to the origin of acceleration in the range 0 -64 000
searchRange origin range (not too large)
searchSpeed ??stop0 search speed (not too high)
phaseSpeed ??Z-phase search speed (not too high)
pulseUnit pulses per revolution

Return value 0: Homing success; -1: Parameter error; -2: fail back to the origin, (the origin met the range limit or too small); 1: back to the origin is suspended
Description:
(1) is divided into four big step back to the origin:
The first step: fast approaching stop0 (logical0 origin set), find stop0;
Step Two: Slow reverse left stop0, reverse pulses moving range specifying the origin;
The third step: slow again close stop0;
Step four: slow close stop1 (logical1 Encoder Z-phase).
(2) can choose whether to perform the fourth step, by logical1 to choose.
(3) For multi-axis back to the origin, must wait for the return to the origin after the end of a shaft, the shaft back to the origin of the next action.

************************************************** ****************/

int home2 (int cardno, int axis, int axis1, int backDir, int backDir1, int logical0, int logical1,
		   int logical2, int logical3, long homeStartV, long homeStartV1, long homeSpeed, long homeSpeed1,
		   long homeAcc, long homeAcc1, long searchRange, long searchRange1, long searchSpeed, long searchSpeed1,
		   long phaseSpeed, long phaseSpeed1, long pulseUnit, long pulseUnit1);
/************************** Two-axis back to the origin ******************* ***
Function: simultaneous two-axis back to the origin of movement
Parameters:
cardno Card
axis axis number (1-4)
axis1 axis number (1-4)
backDir, backDir1 direction back to the origin 0: positive 1: negative

logical0  axis back to the origin set stop0 0: active low 1: active high
logical1  axis back to the origin stop1 set 0: active low 1: active high 1: invalid (does not search for Z-phase)
logical2  axis back to the origin set stop0 0: active low 1: active high
logical3  axis back to the origin stop1 set 0: active low 1: active high 1: invalid (does not search for Z-phase)

homeStartV  axis back to the origin of the initiation speed, range :0-2M
homeStartV1  axis back to the origin of the initiation speed, range :0-2M

homeSpeed  drive shaft back to the origin of the speed, range :0-2M
homeSpeed1 drive shaft back to the origin of the speed, range :0-2M

homeAcc  axis back to the origin of acceleration in the range 0 -64 000
homeAcc1  axis back to the origin of acceleration in the range 0 -64 000

searchRange  axis origin range (not too large)
searchRange1  axis origin range (not too large)

searchSpeed  axis stop0 search speed (not too high)
searchSpeed1  axis stop0 search speed (not too high)

phaseSpeed  axis Z-phase search speed (not too high)
phaseSpeed1  axis Z-phase search speed (not too high)

pulseUnit  axis pulses per revolution
pulseUnit1  axis pulses per revolution
Return value 0: Homing success; -1: Parameter error; -2: fail back to the origin, (the origin met the range limit or too small); 1: back to the origin is suspended
Description:
(1) is divided into four big step back to the origin:
The first step: fast approaching stop0 (logical0 origin set), find stop0;
Step Two: Slow reverse left stop0, reverse pulses moving range specifying the origin;
The third step: slow again close stop0;
Step four: slow close stop1 (logical1 Encoder Z-phase).
(2) can choose whether to perform the fourth step, by logical1 to choose.
(3) For multi-axis back to the origin, must wait for the end of the current axis back to the origin, in order to perform other axis homing action.
************************************************** ****************/

#endif